﻿var questionnaireEditorBlockController = function () {
    var questionnaireEditor = null;

    init = function (_questionnaireEditor) {
        questionnaireEditor = _questionnaireEditor;
        bindEvents();
    }

    bindEvents = function () {
        questionnaireEditor.container.on("dblclick", ".h-newBlock", function () {
            createBlock(null, null,
                function (result) {
                    $("#blocksContainer", questionnaireEditor.container).append(result);
                });
        });

        questionnaireEditor.container.on("click", ".h-expandBlock", function () {
            toggleBlock($(this));
        });

        questionnaireEditor.container.on("mouseenter", ".v-blockPanel, .v-blockStructurePanel", function () {
            blockMouseEnter($(this));
        });

        questionnaireEditor.container.on("mouseleave", ".v-blockPanel, .v-blockStructurePanel", function () {
            blockMouseLeave($(this));
        });

        questionnaireEditor.container.on("click", ".v-blockName .h-deleteSkipLogic", function () {
            var panel = $(this).closest(".v-blockPanel");
            deleteBlockSkipLogic(panel);
        });

        questionnaireEditor.container.on("mouseenter", ".v-blockName .h-blockSkipRulesContainer", function () {
            var self = $(this);

            questionnaireEditor.blockLogicBannerTimer = setTimeout(function () { self.addClass("active"); }, 500);
        });

        questionnaireEditor.container.on("mouseleave", ".v-blockName .h-blockSkipRulesContainer", function () {
            window.clearInterval(questionnaireEditor.blockLogicBannerTimer);
            $(this).removeClass("active");
        });

        questionnaireEditor.container.on("click", ".v-blockName .h-editSkipLogic", function () {
            var panel = $(this).closest(".v-blockPanel");

            var callBack = function (panel) {
                var skipLogicLink = $(".v-skipLogicBlock .v-header", panel);
                skipLogicLink.trigger("click");
            };

            if (questionnaireEditor.unsavedChange()) {
                questionnaireEditor.showUnsavedChangesConfirmation(
                    function () { questionnaireEditor.completedActionCallback = function () { preloadEditBlock(panel, callBack, true); }; questionnaireEditor.savePreviouslyEditedItem(); },
                    function () { questionnaireEditor.cancelPreviouslyEditedItem(); preloadEditBlock(panel, callBack, null); }
                );
            }
            else {
                questionnaireEditor.closePreviouslyEditedItem();
                preloadEditBlock(panel, callBack, null);
            }

        });

        questionnaireEditor.container.on("click", ".h-editBlock", function () {
            var panel = $(this).closest(".v-blockPanel");
            var editBlockContent = panel.find(".v-editBlockContent");
            var blockId = panel.attr("id").replace("blockPanel", "");

            if (questionnaireEditor.unsavedChange()) {
                questionnaireEditor.showUnsavedChangesConfirmation(
                    function () { questionnaireEditor.completedActionCallback = function () { preloadEditBlock(panel, null, true); }; questionnaireEditor.savePreviouslyEditedItem(); },
                    function () { questionnaireEditor.cancelPreviouslyEditedItem(); preloadEditBlock(panel, null, null); }
                );
            }
            else {
                questionnaireEditor.closePreviouslyEditedItem();
                preloadEditBlock(panel, null, null);
            }
        });

        questionnaireEditor.container.on("click", ".v-editBlockContent .v-subSection .v-header", function () {
            var contentBlock = $(this).next(".content");
            var icon = $(this).find("span");

            contentBlock.toggle();
            questionnaireEditor.appendStartValuesForPanel(contentBlock);
            updateSynchronizeWithValues(contentBlock);

            if (contentBlock.is(":visible")) {
                icon.removeClass("fa-caret-right");
                icon.addClass("fa-caret-down");
            } else {
                icon.removeClass("fa-caret-right");
                icon.addClass("fa-caret-down");
            }

            positionBlockMask();

            questionnaireEditor.hideFindQuestionPanel();
        });

        questionnaireEditor.container.on("click", ".h-copyBlock", function () {
            questionnaireEditor.hideFindQuestionPanel();
            var block = $(this).closest(".v-blockPanel");

            var callback = function (result) {
                $("#blocksContainer", questionnaireEditor.container).append(result);
                setTimeout(function () {
                    $('html, body').animate({
                        scrollTop: $("#blocksContainer .block-panel:last .block-item-panel:first").offset().top - 200
                    }, 500);
                }, 20);
            }

            copyBlock(getBlockIdFromElement(block), -1, null, callback);
        });

        questionnaireEditor.container.on("click", ".h-deleteBlock", function () {
            questionnaireEditor.hideFindQuestionPanel();
            var block = $(this).closest(".v-blockPanel");

            if (block.hasClass("inEdit")) {
                //CancelEditBlock();
                questionnaireEditor.clearEditValues();
            }

            deleteBlock(getBlockIdFromElement(block));
        });

        questionnaireEditor.container.on("click", ".h-edit-block-theme", function () {
            var panel = $(this).closest(".v-blockPanel");
            var blockId = panel.attr("id").replace("blockPanel", "");

            modalDialog.showWindow(questionnaireEditor.getUrl("BlockThemeEditor", { blockId: blockId }), "98%", "98%", { closeButton: false });
        });

        questionnaireEditor.container.on("change", ".v-lookAndFeel", function () {
            var block = $(this).closest(".v-blockPanel");

            $(".v-edit-block-theme", block).toggle();
        });

        questionnaireEditor.container.on("click", ".h-save-block-button", function () {
            var block = $(this).parents(".v-blockPanel");
            var editBlockContent = block.find(".v-editBlockContent");
            var randomizationPanel = block.find(".h-randomization-block");
            var id = block.attr("id").replace("blockPanel", "");
            var name = $(".h-block-name", block).val().trim();
            var settings = {};
            var questionsRandomizations = [];
            questionnaireEditor.errorOnRequest = false;

            if (!questionnaireEditor.errorOnRequest) {
                questionnaireEditor.setSettings(editBlockContent, settings);
            }

            if (!questionnaireEditor.errorOnRequest) {
                var skipLogic = a4logicEditor.getLogic($(".v-questionSkipEditor", editBlockContent), true);
                questionnaireEditor.errorOnRequest = a4logicEditor.hasError;

                if (!a4logicEditor.hasError) {
                    settings["skipLogic"] = JSON.stringify(skipLogic);

                    questionsRandomizations = randomizationPanel.find(".v-questionsRandomizationTable .v-questionEditableItem").map(function () { return questionnaireEditor.randomizationObject($(this)); }).get();
                }
            }

            if (!questionnaireEditor.errorOnRequest) {
                var args = { id: id, name: name, settings: settings, questionsRandomizations: questionsRandomizations };
                a4.callServerMethod(questionnaireEditor.getUrl("UpdateBlock"), args,
                    function (result) {
                        $(".v-blockName .v-nameLabel", block).text(name);

                        var logicBanner = result.skipLogicBanner;
                        var displayClass = (logicBanner == "" ? "none" : "inline");
                        $(".v-blockSkipRules", block).html(result.skipLogicBanner);
                        $(".v-blockSkipLogicFlag", block).css('display', displayClass);

                        questionnaireEditor.cleanupSkipLogicEditorAfterSave(editBlockContent, settings["skipLogic"].SyntaxType);

                        closeEditBlock();
                        questionnaireEditor.updateBlockSettings(id, false, false);
                        questionnaireEditor.getBlockById(id).name = name;
                        editBlockContent.empty();
                    },
                    function (error) {
                        a4.onAjaxPageMethodError(error);
                    }
                );
            }
        });

        questionnaireEditor.container.on("click", ".h-selectAll", function () {
            var block = questionnaireEditor.isStructureViewMode ? $(this).closest(".v-blockStructurePanel") : $(this).closest(".v-blockPanel");
            var fn = function () {
                if ($(".v-questionCheck", block).length > 0 || $(".v-pageBreakCheck", block).length > 0) {
                    $(".v-questionCheck, .v-pageBreakCheck", block).prop("checked", true);

                    if (!questionnaireEditor.isStructureViewMode) {
                        questionnaireEditor.questionController.checkSurveyOptionsDisplay();
                    }
                }
            }
            executeActionOnBlock(block, false, fn);
        });

        questionnaireEditor.container.on("click", ".h-unselectAll", function () {
            var block = questionnaireEditor.isStructureViewMode ? $(this).closest(".v-blockStructurePanel") : $(this).closest(".v-blockPanel");
            var fn = function () {
                $(".v-questionCheck, .v-pageBreakCheck", block).prop("checked", false);

                if (!questionnaireEditor.isStructureViewMode) {
                    questionnaireEditor.questionController.checkSurveyOptionsDisplay();
                }
            }

            executeActionOnBlock(block, false, fn);
        });

        questionnaireEditor.container.on("click", ".h-expandQuestions", function () {
            if (questionnaireEditor.isStructureViewMode === true)
                return;
            var block = $(this).closest(".v-blockPanel");
            var questionContentSelector = ".v-editQuestionContent";
            var fn = function () { initializeExpandCollapse($(questionContentSelector + ".hidden", block)); }
            executeActionOnBlock(block, false, fn);
        });

        questionnaireEditor.container.on("click", ".h-collapseQuestions", function () {
            if (questionnaireEditor.isStructureViewMode === true)
                return;
            var block = $(this).closest(".v-blockPanel");
            var questionContentSelector = ".v-editQuestionContent";
            var fn = function () { initializeExpandCollapse($(questionContentSelector + ":not(.hidden)", block)); }
            executeActionOnBlock(block, false, fn);
        });

        questionnaireEditor.container.on("click", ".v-blockTitleEdit", function () {
            var blockTitleEditButton = $(this);

            if (questionnaireEditor.unsavedChange()) {
                questionnaireEditor.showUnsavedChangesConfirmation(
                    function () { questionnaireEditor.completedActionCallback = function () { editBlockTitle(blockTitleEditButton, true); }; questionnaireEditor.savePreviouslyEditedItem(); },
                    function () { questionnaireEditor.cancelPreviouslyEditedItem(); editBlockTitle(blockTitleEditButton, null); }
                );
            }
            else {
                questionnaireEditor.closePreviouslyEditedItem();
                editBlockTitle(blockTitleEditButton, null);
            }

            return false;
        });
    }

    deleteBlockSkipLogic = function (item) {
        var itemId = getBlockIdFromElement(item);

        modalDialog.showConfirmDialog(modalDialog.createDialogResources(sharedResources.DeleteItem, questionnaireEditor.resources.DeleteSkipLogic, null, questionnaireEditor.resources.Delete),
            function () {
                a4.callServerMethod(questionnaireEditor.getUrl("DeleteBlockSkipLogic"), { blockId: itemId },
                    function (result) {
                        $(".v-blockSkipRules", item).html("");
                        $(".v-blockSkipLogicFlag", item).hide();

                        $(".v-skipLogicContainer .v-logicTable .v-questionEditableItem", item).remove();
                        $(".v-skipLogicContainer .v-logicTable", item).attr("style", "display:none;");
                        $(".v-skipLogicContainer .v-filterType", item).attr("style", "display:none;");
                    },
                    function () { }
                );
            }, 250, 500);
    }

    positionBlockMask = function () {
        var container = questionnaireEditor.activeMaskBlock;

        if (container) {
            if (container.css("display") != "none") {
                var questionContainerPosition = container.offset();
                $("#block-mask").height(container.height());
                $("#block-mask").width(container.width());
                $("#block-mask").css("left", questionContainerPosition.left);
                $("#block-mask").css("top", questionContainerPosition.top);
            } else {
                var questionContainerPosition = container.offset();
                $("#block-mask").height(0);
                $("#block-mask").width(0);
                $("#block-mask").css("left", 0);
                $("#block-mask").css("top", 0);
            }
        }
    }

    initBlockDefaultPreview = function (block) {
        var content = block ? block : questionnaireEditor.container;
        var questionsContainer = $(".v-questionsContainer:not(.hidden)", content);

        if (questionsContainer) {
            var editableContent = $(".v-editQuestionContent:not(.hidden)", questionsContainer);
            var blockItemPanel = editableContent.closest(".v-blockItemPanel");
            var questionType = blockItemPanel.find(".v-questionEdit").attr("data-qtypename");

            questionnaireEditor.setDisplayQuestionTypePreview(blockItemPanel, questionType);
        }
    }

    blockMouseEnter = function (blockPanel) {
        $(".v-blockOptions", blockPanel).show();
        $(".v-moveBlock", blockPanel).show();
        blockPanel.addClass("focus");

        if ($(".v-questionsContainer", blockPanel).is(":hidden") && questionnaireEditor.blockItemDragActive) {
            questionnaireEditor.expandBlockTimer = setTimeout(function () { $(".v-blockName", blockPanel).trigger('click'); }, 2000);
        }
    }

    blockMouseLeave = function (blockPanel) {
        $(".v-blockOptions", blockPanel).hide();
        $(".v-moveBlock", blockPanel).hide();
        blockPanel.removeClass("focus");

        if (questionnaireEditor.expandBlockTimer) {
            window.clearTimeout(questionnaireEditor.expandBlockTimer);
        }
    }

    ensureBlockInstructionsRemoved = function (block) {
        if ($(".v-blockEmpty", block).length > 0) {
            $(".v-blockEmpty", block).remove();
        }
    }

    updateSynchronizeWithValues = function (_editor) {
        var _synchronizedWithOptions = "";

        $(".v-questionEditableItem:visible", _editor).each(function () {
            var _randomizationIndex = $(this).find(".v-itemIndex").text();
            var _randomizationValue = $(this).attr("id").replace("RandomizationRow", "");

            if (_randomizationIndex != "[randomizationNb]") {
                _synchronizedWithOptions += "<option value='" + _randomizationValue + "'>" + _randomizationIndex + "</option>";
            }
        });

        $(".synchronizeWith", _editor).each(function () {
            var _selectedValue = $(this).val();
            $(this).html(_synchronizedWithOptions);
            $(this).val(_selectedValue);
        });
    }

    createBlock = function (previousBlockId, position, callback) {
        a4.callServerMethod(questionnaireEditor.getUrl("AddBlock"), { previousBlockId: previousBlockId, position: position },
            function (result) {
                completeAddBlock(result, callback);
            });
    }

    copyBlock = function (blockId, previousBlockId, position, callback) {
        a4.callServerMethod(questionnaireEditor.getUrl("CopyBlock"), { blockId: blockId, previousBlockId: previousBlockId, position: position, nbQuestions: _.size(questionnaireEditor.questions) },
            function (result) {
                completeAddBlock(result, callback);
            });
    }

    moveBlock = function (blockId, previousBlockId, nextBlockId, moveUp) {
        a4.callServerMethod(questionnaireEditor.getUrl("MoveBlock"), { blockId: blockId, previousBlockId: previousBlockId, nextBlockId: nextBlockId, moveUp: moveUp },
            function () {
                var block = questionnaireEditor.getBlockById(blockId);
                var previousBlockPosition = (previousBlockId == null) ? -1 : questionnaireEditor.getBlockById(previousBlockId).position;

                _.each(_.filter(questionnaireEditor.blocks, function (b) { return b.position > previousBlockPosition }), function (fb) {
                    fb.position += 1;
                });

                _.each(_.filter(questionnaireEditor.questions, function (q) { return q.blockPosition > previousBlockPosition }), function (i) {
                    i.blockPosition += 1;
                });

                var newPosition = previousBlockPosition + 1;
                block.position = newPosition;

                _.each(_.filter(questionnaireEditor.questions, function (q) { return q.blockId == blockId }), function (i) {
                    i.blockPosition = newPosition;
                });

                questionnaireEditor.checkSurveyMenuStatus();
            });
    }

    completeAddBlock = function (result, callback) {
        callback(result.content);
        var newBlock = $(".v-questionsContainer", getBlockElementFromId(result.id));
        questionnaireEditor.setBlockItemsSortable(newBlock);
        questionnaireEditor.addItemsToSettings(JSON.parse(result.settings));
        var nbQuestions = _.size(questionnaireEditor.getQuestionsByBlockId(result.id));
        questionnaireEditor.refreshQuestionnaireTotalCount(1, nbQuestions);
        questionnaireEditor.checkSurveyMenuStatus();
        initBlockDefaultPreview(newBlock.parent());
    }

    toggleBlock = function (button, findQuestion, callback, noMoveOnCallback) {
        var blockPanel = button.closest(".v-blockPanel");

        if (blockPanel.length === 0)
            return;

        var id = getBlockIdFromElement(blockPanel);

        var openBlock = $(".v-questionsContainer", blockPanel).is(":hidden");
        $(".block-header .h-expandBlock:not(.v-blockName)", blockPanel).toggle();

        if (blockPanel.hasClass("loaded") || blockPanel.hasClass("loading")) {
            completeButtonToggle(id, blockPanel, openBlock, findQuestion, callback);
        }
        else {
            blockPanel.addClass("loading");
            $(".h-waiting-icon", blockPanel).show();

            if (callback && (noMoveOnCallback == undefined || !noMoveOnCallback)) {
                setTimeout(function () {
                    $('html, body').animate({
                        scrollTop: blockPanel.offset().top - 20
                    }, 500);
                }, 20);
            }

            loadBlockContent(id, blockPanel, openBlock, findQuestion, callback, true);
        }
    }

    loadBlockContent = function (id, blockPanel, openBlock, findQuestion, callback, toggle) {
        a4.callServerMethod(questionnaireEditor.getUrl("GetBlockItems"), { blockId: id },
            function (result) {
                if (result != "") {
                    $(".h-waiting-icon", blockPanel).hide();
                    var htmlResult = $('<div/>').html(result);
                    var questions = $(".v-questionsContainer", htmlResult).html();

                    try {
                        // Prevent invalid js from blocking the block load
                        $(".v-questionsContainer", blockPanel).append(questions);
                    }
                    catch (err) { }

                    blockPanel.removeClass("loading").addClass("loaded");

                    if (toggle) {
                        completeButtonToggle(id, blockPanel, openBlock, findQuestion, callback);

                        // Refresh sortables when getting new block (important when currently dragging)
                        if (questionnaireEditor.blockItemDragActive) {

                            // Add sortable for loaded block
                            var sortableContainer = $(".v-questionsContainer", blockPanel);
                            questionnaireEditor.setBlockItemsSortable(sortableContainer);

                            // Reset positions of sortables for loaded blocks - required for correct positionning
                            var blockContainer = $("#blocksContainer", questionnaireEditor.container);

                            $(".v-blockPanel.loaded .v-questionsContainer", blockContainer).each(function () {
                                $(this).sortable("refresh");
                            });

                            // Set callback so that drag refreshes container
                            questionnaireEditor.completedActionCallback = true;
                        }

                    }
                    else if (callback) {
                        callback();
                    }
                }
            },
            function () { }
        );
    }

    completeButtonToggle = function (id, blockPanel, openBlock, findQuestion, callback) {
        $(".v-questionsContainer", blockPanel).toggle(openBlock);

        // If we open block
        if (openBlock && (findQuestion == undefined || !findQuestion)) {
            //$(".blockTotal", blockPanel).hide();

            if (!blockPanel.hasClass("expanded")) {
                $(".v-editQuestionContent", blockPanel).each(function () {
                    var item = $(this).closest(".blockItemPanel");
                    $(".question-logic-div", item).toggle(item.hasClass("has-logic"));
                });
                blockPanel.addClass("expanded");
            }

            // Set callback so that drag refreshes container
            if (questionnaireEditor.blockItemDragActive) {
                $(".v-blockPanel.loaded .v-questionsContainer", questionnaireEditor.container).each(function () {
                    $(this).sortable("refresh");
                });

                questionnaireEditor.completedActionCallback = true;
            }

            questionnaireEditor.updateConfiguration(id, null);
        }
        else {
            questionnaireEditor.activeBlock = id;
            blockPanel.removeClass("expanded");
        }

        if (callback != undefined) {
            callback();
        }
    }

    executeActionOnBlock = function (block, open, callback) {
        if (!block.hasClass("loaded")) {
            loadBlockContent(getBlockIdFromElement(block), block, open, false, callback, open);
        }
        else if (callback) {
            callback();
        }
    }

    preloadEditBlock = function (panel, callBack, ignoreRequestInProcess) {
        var editBlockContent = panel.find(".v-editBlockContent");
        var blockId = panel.attr("id").replace("blockPanel", "");

        if (!a4.ajaxRequestInProcess || ignoreRequestInProcess) {

            if (editBlockContent.html().trim() == "") {
                a4.callServerMethod(questionnaireEditor.getUrl("GetEditBlockPanel"), { blockId: blockId },
                    function (result) {
                        editBlockContent.html(result);
                        editBlock(panel, callBack);
                    },
                    function () { }
                );
            } else {
                editBlock(panel, callBack);
            }
        }
    }

    editBlock = function (block, callBack) {
        var fadeDuration = 100;
        var editBlockContent = block.find(".v-editBlockContent");
        var questionContainer = block.find(".questions-container");
        var editBlockContentCancel = editBlockContent.find(".h-cancel-btn");
        var toggleButton = block.find(".v-expandButton");
        var blockId = getBlockIdFromElement(block);
        block.addClass("inEdit");

        setBlockRandomization(editBlockContent, blockId);

        a4logicEditor.variableSource = questionnaireEditor.getSortedVariables();
        a4logicEditor.setVariableAutoComplete($(".v-questionSkipEditor", block));

        questionnaireEditor.setEditStartValues(editBlockContent, null);

        editBlockContent.slideDown(fadeDuration, function () {
            if (callBack) {
                callBack(block);
            }
        });

        editBlockContentCancel.on("click", function () {
            cancelEditBlock();
        })
    }

    setBlockRandomization = function (editBlockContent, blockId) {
        var questionRandomizationEditor = editBlockContent.find(".v-questionsRandomizationEditor");
        var questionRandomizationTable = questionRandomizationEditor.find(".v-questionsRandomizationTable");

        var startQuestionField = $(".h-startquestion-autocomplete", questionRandomizationTable);
        var endQuestionField = $(".h-endquestion-autocomplete", questionRandomizationTable);
        var randomizationQuestionField = $(".h-randomization-autocomplete", questionRandomizationTable);
        var groupByField = $(".h-groupCount", questionRandomizationTable);
        var questions = questionnaireEditor.getQuestionsByBlockId(blockId);

        startQuestionField.a4autocomplete({
            valueProperty: "value",
            labelProperty: "name",
            data: questions
        });

        endQuestionField.a4autocomplete({
            valueProperty: "value",
            labelProperty: "name",
            data: questions
        });

        randomizationQuestionField.a4autocomplete({
            valueProperty: "Value",
            labelProperty: "Label",
            data: _.filter(questionnaireEditor.resources["RandomizationPatterns"], function (r) { return r.Value != null && r.Value != 4 && r.Value != 5; }),
            select: function (event, ui) {
                questionnaireEditor.setChangeRandomizationPatternEvent($(this))
            }
        });

        groupByField.autoNumeric({ aPad: false, vMin: '0', vMax: '100', mDec: '0', aSep: '' });
    }

    closeEditBlock = function () {
        var panel = $(".v-editBlockContent:visible", questionnaireEditor.container);
        var blockContainer = panel.closest(".block-panel");
        var questionContainerMask = blockContainer.find(".mask", questionnaireEditor.container);

        blockContainer.removeClass("inEdit");
        panel.empty();
        panel.hide();
        return false;
    }

    cancelEditBlock = function () {
        var editPanel = $(".v-editBlockContent:visible", questionnaireEditor.container);
        var panel = editPanel.closest(".v-blockPanel");

        // Verify that we were editing a block
        if (panel.length > 0) {
            questionnaireEditor.resetEditStartValues(panel);
            questionnaireEditor.clearEditValues();
        }

        editPanel.empty();

        closeEditBlockTogglables(panel);
        closeEditBlock();
        return false;
    }

    closeEditBlockTogglables = function (panel) {
        $.each($(".v-subSection .v-header", panel), function () {
            var contentBlock = $(this).next(".content");
            var icon = $(this).find("span");

            if (contentBlock.is(":visible")) {
                contentBlock.toggle();
                icon.removeClass("fa-caret-down");
                icon.addClass("fa-caret-right");
            }
        });
    }

    deleteBlockConfirmed = function (block, blockId) {
        a4.callServerMethod(questionnaireEditor.getUrl("DeleteBlock"), { blockId: blockId, checkType: 2 },
            function (result) {
                block.remove();
                var nbQuestions = _.size(questionnaireEditor.getQuestionsByBlockId(blockId));
                questionnaireEditor.updateBlockSettings(blockId, true, false);
                questionnaireEditor.refreshQuestionnaireTotalCount(-1, (nbQuestions * -1));
                questionnaireEditor.removeReferencedBanners(blockId, false);
            });
    }

    deleteBlock = function (blockId) {
        if (!a4.ajaxRequestInProcess) {
            var block = getBlockElementFromId(blockId);
            var nbQuestions = _.size(questionnaireEditor.getQuestionsByBlockId(blockId));

            if (nbQuestions == 0) {
                modalDialog.showConfirmDialog(modalDialog.createDialogResources(sharedResources.DeleteItem, questionnaireEditor.resources.DeleteBlock, null, questionnaireEditor.resources.Delete),
                    function () {
                        deleteBlockConfirmed(block, blockId);
                    }, 220, 500);
            }
            else {
                // First get all the conflicts
                a4.callServerMethod(questionnaireEditor.getUrl("DeleteBlock"), { blockId: blockId, checkType: 1 },
                    function (result) {
                        var height = 270;
                        var deleteContainer = $("#deleteBlockContainer", questionnaireEditor.container).clone();
                        height = questionnaireEditor.addConflictsToContent(deleteContainer, result.conflicts, height);

                        var deleteContent = deleteContainer.html().replace("{0}", $(".block-header .v-blockName .v-nameLabel", block).text()).replace("{1}", nbQuestions);
                        deleteContent = $('<div/>').html(deleteContent);

                        modalDialog.showConfirmDialog(modalDialog.createDialogResources(deleteContent.html(), questionnaireEditor.resources.DeleteBlock, questionnaireEditor.resources.DeleteBlockCheck, questionnaireEditor.resources.Delete),
                            function () {
                                deleteBlockConfirmed(block, blockId)
                            }, height, 600, true);
                    },
                    function () { }
                );
            }
        }
    }

    initializeExpandCollapse = function (questions) {
        if (questions.length > 0) {
            $("body").addClass("wait");
            setTimeout(function () { executeExpandCollapse(questions) }, 0);
        }
    }

    executeExpandCollapse = function (questions) {
        questions.each(function () {
            expandCollapseBlockItem($(this));
        });

        $("body").removeClass("wait");
    }

    expandCollapseBlockItem = function (questionContent) {
        var item = $(".h-questionTitle", questionContent.prev(".item-header:first"));

        if (item.length > 0) {
            questionnaireEditor.toggleQuestion(item, false);
            questionnaireEditor.questionController.questionMouseLeave(item.closest(".v-blockItemPanel"));
        }
    }

    editBlockTitle = function (blockEditTitleButton, ignoreRequestInProcess) {
        questionnaireEditor.activeBlock = getBlockIdFromElement(blockEditTitleButton.closest(".v-blockPanel"));

        if (!a4.ajaxRequestInProcess || ignoreRequestInProcess) {

            var blockNameEditIcon = blockEditTitleButton.clone();
            var blockPanel = blockEditTitleButton.closest(".v-blockPanel");
            var blockId = blockPanel.attr("id").replace("blockPanel", "");
            var blockTitleGroupContainer = blockPanel.find(".v-blockTitleGroup");
            var blockTitleZoneContainer = blockPanel.find(".v-blockTitleEditZone");
            var blockTitleContainer = blockPanel.find(".v-nameLabel");
            var blockName = blockTitleContainer.html();
            var blockNameInput = $("<input id=\"editBlockTitle" + blockId + "\" type=\"text\" value=\"" + blockName + "\">")
                .on("click", function () {
                    return false;
                });

            blockNameInput.keypress(function (e) { return questionnaireEditor.disableInvalidCharacters(e); });

            questionnaireEditor.editValues[blockNameInput.attr("id")] = blockNameInput.val();

            var blockNameEditLoadingIcon = $(voxco.icons.getIcon("loading", "v-blockTitleEditLoading"));

            var blockNameEditCancelButton = $(voxco.icons.getIcon("remove", "v-blockTitleEditCancel", { Title: questionnaireEditor.resources.Cancel }))
                .on("click", function () {
                    closeEditBlockTitle();
                    questionnaireEditor.clearEditValues();
                });

            var blockNameEditConfirmButton = $(voxco.icons.getIcon("check", "v-blockTitleEditConfirm", { Title: questionnaireEditor.resources.Confirm }))
                .on("click", function () {
                    var newBlockName = blockNameInput.val();

                    blockNameEditConfirmButton.hide();
                    blockNameEditCancelButton.hide();
                    blockNameInput.after(blockNameEditLoadingIcon);

                    if (newBlockName.trim() !== "") {
                        a4.callServerMethod(questionnaireEditor.getUrl("UpdateBlock"), { id: blockId, name: newBlockName, settings: null, questionsRandomizations: null },
                            function (result) {
                                var block = questionnaireEditor.getBlockById(blockId);
                                block.name = newBlockName;
                                blockTitleContainer.html(newBlockName);

                                closeEditBlockTitle();

                                questionnaireEditor.clearEditValues();

                                questionnaireEditor.executeGlobalCallback(false);
                            },
                            function (error) {
                                a4.onAjaxPageMethodError(error);
                                blockNameEditLoadingIcon.remove();
                                blockNameEditConfirmButton.show();
                                blockNameEditCancelButton.show();
                            }
                        );
                    } else {
                        a4.showErrorMessage(questionnaireEditor.resources.BlockNameIsRequired);
                    }

                    return false;
                });

            blockNameInput.keypress(function (event) {
                if (event.keyCode == 13) {
                    blockNameEditConfirmButton.trigger("click");
                }
            });

            blockTitleZoneContainer.hide();

            blockTitleGroupContainer.prepend(blockNameEditConfirmButton);
            blockTitleGroupContainer.prepend(blockNameEditCancelButton);
            blockTitleGroupContainer.prepend(blockNameInput);
            blockNameInput.trigger("focus");

            blockTitleGroupContainer.addClass("inEditTitle");
        }
    }

    closeEditBlockTitle = function () {
        var blockitem = getInEditBlockTitle();

        if (blockitem.length > 0) {
            var editInput = blockitem.find("input[type=text]");
            var cancelButton = blockitem.find(".v-blockTitleEditCancel");
            var confirmButton = blockitem.find(".v-blockTitleEditConfirm");
            var loadingIcon = blockitem.find(".v-blockTitleEditLoading");
            var blockTitleEditZone = blockitem.find(".v-blockTitleEditZone");

            blockitem.removeClass("inEditTitle");
            cancelButton.remove();
            confirmButton.remove();
            loadingIcon.remove();
            editInput.remove();
            blockTitleEditZone.show();
        }
    }

    cancelEditBlockTitle = function () {
        var panel = getInEditBlockTitle();

        // Verify that we were editing a question title
        if (panel.length > 0) {
            questionnaireEditor.clearEditValues();
        }

        closeEditBlockTitle();
    }

    getInEditBlockTitle = function () {
        return $(".v-blockTitleGroup.inEditTitle", questionnaireEditor.container);
    }

    getBlockIdFromElement = function (item) {
        return item.closest(".v-blockPanel").attr("id").replace("blockPanel", "");
    }

    getBlockElementFromId = function (itemId) {
        return $("#blocksContainer #blockPanel" + itemId, questionnaireEditor.container);
    }

    getBlockItemIdFromElement = function (item) {
        return item.closest(".v-blockItemPanel").attr("id").replace("blockItemPanel", "");
    }

    getBlockItemElementFromId = function (itemId) {
        return $("#blocksContainer #blockItemPanel" + itemId, questionnaireEditor.container);
    }

    getBlockItemElementInBlockWithId = function (block, itemId) {
        return $("#blockItemPanel" + itemId, block);
    }

    return {
        init: init,
        positionBlockMask: positionBlockMask,
        initBlockDefaultPreview: initBlockDefaultPreview,
        blockMouseLeave: blockMouseLeave,
        updateSynchronizeWithValues: updateSynchronizeWithValues,
        createBlock: createBlock,
        copyBlock: copyBlock,
        moveBlock: moveBlock,
        completeAddBlock: completeAddBlock,
        toggleBlock: toggleBlock,
        loadBlockContent: loadBlockContent,
        executeActionOnBlock: executeActionOnBlock,
        closeEditBlock: closeEditBlock,
        cancelEditBlock: cancelEditBlock,
        initializeExpandCollapse: initializeExpandCollapse,
        closeEditBlockTitle: closeEditBlockTitle,
        cancelEditBlockTitle: cancelEditBlockTitle,
        getBlockIdFromElement: getBlockIdFromElement,
        getBlockElementFromId: getBlockElementFromId,
        getBlockItemIdFromElement: getBlockItemIdFromElement,
        getBlockItemElementFromId: getBlockItemElementFromId,
        getBlockItemElementInBlockWithId: getBlockItemElementInBlockWithId,
        ensureBlockInstructionsRemoved: ensureBlockInstructionsRemoved
    }
}